<?php


namespace App\Controllers\Admin;


use App\Models\CategoriaPdf;

class CategoriaPdfController
{
    public function categorias()
    {
        return CategoriaPdf::orderBy('nome','ASC')->get();
    }
    public function store($data)
    {
        CategoriaPdf::create($data);
    }

    public function edit($id)
    {
        return CategoriaPdf::find($id);
    }

    public function update($data)
    {
        $categoria = CategoriaPdf::find($data['id']);
        $categoria->update($data);
    }

    public function destroy($data)
    {
        $categoria = CategoriaPdf::find($data['id']);
        foreach ($categoria->pdfs as $pdf) {
            $this->removerArquivo($pdf->file_name);
            $pdf->delete();
        }
        $categoria->delete();
    }

    private function removerArquivo($arquivo)
    {
        if (file_exists('../uploads/pdf/' . $arquivo)) {
            @unlink('../uploads/pdf/' . $arquivo);
        }
    }
}