<?php


namespace App\Controllers\Admin;


use App\Models\Frota;

class FrotaController
{
    public function frotas()
    {
        return Frota::all();
    }

    public function store($data)
    {
        $frota = Frota::create($data);
        return $frota->id;
    }

    public function edit($id)
    {
        return Frota::find($id);
    }

    public function update($data)
    {
        Frota::find($data['id'])->update($data);
    }

    public function destroy($data)
    {
        $frota = Frota::find($data['id']);
        foreach ($frota->fotos as $foto) {
            $this->removerImagem($foto->url);
            $foto->delete();
        }
        $frota->delete();
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/frota/' . $imagem)) {
            @unlink('../uploads/frota/' . $imagem);
        }
    }
}