<?php


namespace App\Controllers\Admin;

use App\Models\GaleriaFoto;

class GaleriaFotoController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = GaleriaFoto::find($photo_id);
            $this->removerImagem($photo->url);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/galeria/' . $imagem)) {
            @unlink('../uploads/galeria/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            GaleriaFoto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/galeria/" . $url)) {
                $galeria_id = $_REQUEST['galeria_id'];
                $foto = GaleriaFoto::create([
                    'url' => $url,
                    'galeria_id' => $galeria_id,
                ]);
                echo json_encode(array('url' => $foto->url, 'id' => $foto->id));
            }
        }
    }
}