<?php


namespace App\Controllers\Admin;


use App\Models\Noticia2Foto;

class Noticia2FotoController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = Noticia2Foto::find($photo_id);
            $this->removerImagem($photo->file_name);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/noticia/' . $imagem)) {
            @unlink('../uploads/noticia/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            Noticia2Foto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/noticia/" . $url)) {
                $noticia_id = $_REQUEST['id'];
                $foto = Noticia2Foto::create([
                    'file_name' => $url,
                    'noticia2_id' => $noticia_id,
                ]);
                echo json_encode(array('file_name' => $foto->file_name, 'id' => $foto->id));
            }
        }
    }
}