<?php


namespace App\Controllers\Admin;


use App\Models\Pdf;

class PdfController
{
    public function pdfs()
    {
        return Pdf::all();
    }

    public function store($data)
    {
        $arquivo = $this->upload();
        $array = array_merge(['file_name' => $arquivo], $data);
        Pdf::create($array);
    }

    public function edit($id)
    {
        $pdf = Pdf::find($id);
        return $pdf;
    }

    public function update($data)
    {
        $pdf = Pdf::find($data['id']);
        if (isset($_FILES['file_name']['name']) && !empty($_FILES['file_name']['name'])) {
            $this->removerArquivo($pdf->file_name);
            $arquivo = $this->upload();
            $data = ['file_name' => $arquivo] + $data;
        }
        $pdf->update($data);
    }

    public function destroy($data)
    {
        $pdf = Pdf::find($data['id']);
        $this->removerArquivo($pdf->file_name);
        $pdf->delete();
    }

    public function upload()
    {
        $ext = strtolower(substr($_FILES['file_name']['name'], -4));
        $url = uniqid(time(), true) . $ext;
        move_uploaded_file($_FILES['file_name']['tmp_name'], "../uploads/pdf/" . $url);
        return $url;
    }

    private function removerArquivo($arquivo)
    {
        if (file_exists('../uploads/pdf/' . $arquivo)) {
            @unlink('../uploads/pdf/' . $arquivo);
        }
    }
}