<?php


namespace App\Controllers\Admin;


use App\Models\Venda;

class VendaController
{
    public function vendas()
    {
        return Venda::all();
    }

    public function store($data)
    {
        $venda = Venda::create($data);
        return $venda->id;
    }

    public function venda($id)
    {
        return Venda::with('fotos')->find($id);
    }

    public function update($data)
    {
        $venda = Venda::find($data['id']);
        $venda->update($data);
    }

    public function destroy($data)
    {
        $venda = Venda::find($data['id']);
        foreach ($venda->fotos as $item) {
            $this->removeFoto($item->url);
            $item->delete();
        }
        $venda->delete();
    }

    private function removeFoto($imagem)
    {
        if (file_exists('../uploads/vendas/' . $imagem)) {
            @unlink('../uploads/vendas/' . $imagem);
        }
    }
}