<?php


namespace App\Controllers\Admin;


use App\Models\VendaFoto;

class VendaFotoController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = VendaFoto::find($photo_id);
            $this->removerImagem($photo->url);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/vendas/' . $imagem)) {
            @unlink('../uploads/vendas/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            VendaFoto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/vendas/" . $url)) {
                $venda_id = $_REQUEST['venda_id'];
                $foto = VendaFoto::create([
                    'url' => $url,
                    'venda_id' => $venda_id,
                ]);
                echo json_encode(array('url' => $foto->url, 'id' => $foto->id));
            }
        }
    }
}