<?php


namespace App\Controllers\Admin;

use App\Models\Viagem2Foto;

class Viagem2FotoController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = Viagem2Foto::find($photo_id);
            $this->removerImagem($photo->file_name);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/viagem/' . $imagem)) {
            @unlink('../uploads/viagem/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            Viagem2Foto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/viagem/" . $url)) {
                $viagem_id = $_REQUEST['id'];
                $foto = Viagem2Foto::create([
                    'file_name' => $url,
                    'viagem2_id' => $viagem_id,
                ]);
                echo json_encode(array('file_name' => $foto->file_name, 'id' => $foto->id));
            }
        }
    }
}