<?php


namespace App\Controllers\Admin;


use App\Models\Viagem;

class ViagemController
{
    public function viagens()
    {
        return Viagem::all();
    }

    public function store($data)
    {
        $viagem = Viagem::create($data);
        return $viagem->id;
    }

    public function edit($id)
    {
        return Viagem::find($id);
    }

    public function update($data)
    {
        Viagem::find($data['id'])->update($data);
    }

    public function destroy($data)
    {
        $viagem = Viagem::find($data['viagem_id']);
        foreach ($viagem->fotos as $foto) {
            $this->removerImagem($foto->url);
            $foto->delete();
        }
        $viagem->delete();
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/viagem/' . $imagem)) {
            @unlink('../uploads/viagem/' . $imagem);
        }
    }
}