<?php


namespace App\Controllers\Admin;


use App\Models\ViagemFoto;

class ViagemFotoController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = ViagemFoto::find($photo_id);
            $this->removerImagem($photo->url);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/viagem/' . $imagem)) {
            @unlink('../uploads/viagem/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            ViagemFoto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/viagem/" . $url)) {
                $viagem_id = $_REQUEST['viagem_id'];
                $foto = ViagemFoto::create([
                    'url' => $url,
                    'viagem_id' => $viagem_id,
                ]);
                echo json_encode(array('url' => $foto->url, 'id' => $foto->id));
            }
        }
    }
}