<?php


namespace App\Controllers\Admin;


use App\Models\Video;
use Embed\Embed;

class VideoController
{
    public function videos()
    {
        return Video::orderBy('id', 'DESC')->get();
    }

    public function video($id)
    {
        return Video::find($id)->toJson();
    }

    public function store($data)
    {
        $info = Embed::create(addslashes(trim($_POST['url'])));
        Video::create([
            'nome' => $data['nome'],
            'url' => $data['url'],
            'thumb' => $info->getImage(),
        ]);
    }

    public function update($data)
    {
        $info = Embed::create(addslashes(trim($_POST['url'])));
        Video::find($data['id'])->update([
            'nome' => $data['nome'],
            'url' => $data['url'],
            'thumb' => $info->getImage(),
        ]);
    }

    public function destroy($data)
    {
        Video::find($data['id'])->delete();
    }
}