<?php


namespace App\Controllers\Site;

use App\Models\Noticia;
use App\Models\NoticiaFoto;

class NoticiaController
{
    public function noticiaHome()
    {
        return Noticia::addSelect([
            'foto' => NoticiaFoto::select('url')->whereColumn('noticia_id', 'noticias.id')->orderBy('pos', 'ASC')->limit(1)
        ])->where('status', '=', 1)->get();
    }

    public function noticias()
    {
        return Noticia::addSelect([
            'foto' => NoticiaFoto::select('url')->whereColumn('noticia_id', 'noticias.id')->orderBy('pos', 'ASC')->limit(1)
        ])->get();
    }

    public function noticia($id)
    {
        $noticia = Noticia::with('fotos')->find($id);
        return $noticia;
    }
}