<?php


namespace App\Controllers\Site;


use App\Models\Viagem;
use App\Models\ViagemFoto;

class ViagemController
{
    public function viagemHome() {
        return Viagem::addSelect([
            'foto' => ViagemFoto::select('url')->whereColumn('viagem_id', 'viagems.id')->orderBy('pos', 'ASC')->limit(1)
        ])->where('status', '=', 1)->get();
    }

    public function viagem($id)
    {
        $viagem = Viagem::with('fotos')->find($id);
        return $viagem;
    }

    public function viagens()
    {
        $viagens = Viagem::addSelect([
            'foto' => ViagemFoto::select('url')->whereColumn('viagem_id', 'viagems.id')->orderBy('pos', 'ASC')->limit(1)
        ])->get();
        return $viagens;
    }
}