<?php

namespace App\Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Noticia
 */
class Venda extends Eloquent
{
    protected $fillable = [
        'titulo', 'descricao',
    ];

    public function fotos()
    {
        return $this->hasMany(VendaFoto::class)->orderBy('pos', 'ASC');
    }
}
