<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Noticia
 */
class Vendas extends Eloquent
{
    public $timestamps = false;
    protected $fillable = [
        'titulo', 'descricao',
    ];

    public function fotos()
    {
        return $this->hasMany('Models\Fotove')->orderBy('pos', 'ASC');
    }

    public function edit($id)
    {
        return Vendas::find($id);
    }

    public function show()
    {
        return Vendas::orderBy('id', 'DESC')->get();
    }

    public function limit() {
        return Vendas::orderBy('id', 'DESC')->take(3)->get();
    }

    public function paginate()
    {
        return Vendas::orderBy('id', 'DESC')->paginate(12);
    }

}
