<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * 
 * Classe video
 * 
 * 
 */
class Agenda extends Eloquent {

    protected $primaryKey = 'agenda_id';
    protected $table = 'agenda';
    public $timestamps = false;
    protected $fillable = [
        'agenda_nome', 'agenda_arquivo',
    ];

    public function show() {
        return Agenda::orderBy('agenda_id', 'DESC')->get();
    }
    
    public function paginate() {
        return Agenda::orderBy('agenda_id', 'DESC')->paginate(24);
    }

}
