<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * 
 * Classe video
 * 
 * 
 */
class Escala extends Eloquent {

    protected $primaryKey = 'escala_id';
    protected $table = 'escala';
    public $timestamps = false;
    protected $fillable = [
        'escala_nome', 'escala_arquivo',
    ];

    public function show() {
        return Escala::orderBy('escala_id', 'DESC')->get();
    }
    
    public function paginate() {
        return Escala::orderBy('escala_id', 'DESC')->paginate(24);
    }

}
