<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 */
class Foto extends Eloquent {

    public $timestamps = false;
    protected $fillable = [
        'url', 'pos', 'galeria_id'
    ];

    public function FotoByGaleria($id) {
        return Foto::where('foto_galeria', '=', $id)->orderBy('foto_pos', 'ASC')->get();
    }


    public function count($id) {
        return Foto::where('foto_galeria', '=', $id)->count();
    }

}
