<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Noticia
 */
class Noticia extends Eloquent {

    protected $primaryKey = 'noticia_id';
    protected $table = 'noticia';
    public $timestamps = false;
    protected $fillable = [
        'noticia_nome', 'noticia_descricao', 'noticia_data', 'noticia_imagem',
        'noticia_status',
    ];

    public function edit($id) {
        return Noticia::find($id);
    }

    public function show() {
        return Noticia::orderBy('noticia_id', 'DESC')->get();
    }

    public function status() {
        return Noticia::where('noticia_status', '=', 1)->get();
    }
    
    public function paginate() {
        return Noticia::orderBy('noticia_id', 'DESC')->paginate(12);
    }

}
