<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Viagem
 */
class Viagem extends Eloquent {

    protected $primaryKey = 'viagem_id';
    protected $table = 'viagem';
    public $timestamps = false;
    protected $fillable = [
        'viagem_nome', 'viagem_nome1', 'viagem_nome2', 'viagem_nome3', 'viagem_nome4', 'viagem_nome5', 'viagem_descricao', 'viagem_status', 'viagem_pdf',
    ];

    public function edit($id) {
        return Viagem::find($id);
    }

    public function show() {
        return Viagem::orderBy('viagem_id', 'DESC')->get();
    }

    public function status() {
        return Viagem::where('viagem_status', '=', 1)->get();
    }
    
    public function paginate() {
        return Viagem::orderBy('viagem_id', 'DESC')->paginate(12);
    }

}
