<?php
require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$artigo = (new \Models\Artigo)->edit(intval($_GET['id']));
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>ADMIN | Galeria de Fotos</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/dropzone/dropzone.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css" />
        <link href="plugins/summernote/summernote.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css" />
        <link href="plugins/iCheck/all.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="plugins/jQuery/html5shiv.min.js"></script>
            <script src="plugins/jQuery/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="skin-blue sidebar-mini">
        <div class="wrapper">
            <header class="main-header">
                <?php require_once './topo.php'; ?>
            </header>
            <aside class="main-sidebar">
                <?php require_once './menu.php'; ?>
            </aside>
            <div class="content-wrapper">
                <section class="content-header">
                    <h1>Artigo</h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Artigo</li>
                    </ol>
                </section>
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary">
                                <div class="box-header">
                                    <h3 class="box-title"><i class="fa fa-save"></i> Editar informações</h3>
                                </div>
                                <div class="box-body">
                                    <form  enctype="multipart/form-data" method="post" action="artigo_fn.php?acao=atualizar">

                                        <div class="modal-body" id="hoshi">
                                            <span class="input input--hoshi">
                                                <input class="input__field input__field--hoshi" type="text" name="artigo_nome" required value="<?= $artigo->artigo_nome ?>" />
                                                <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="artigo_nome">
                                                    <span class="input__label-content input__label-content--hoshi">Título</span>
                                                </label>
                                            </span>
                                            <div class="row">
                                                <div class="col-md-2">
                                                    <span class="input input--hoshi">
                                                        <input class="input__field input__field--hoshi" id="data" type="text" name="artigo_data" value="<?= Format::InverterData($artigo->artigo_data) ?>" />
                                                        <input type="hidden" name="artigo_id" value="<?= $artigo->artigo_id ?>" />
                                                        <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="artigo_data">
                                                            <span class="input__label-content input__label-content--hoshi">Data</span>
                                                        </label>
                                                    </span>
                                                </div>
                                                <div class="col-md-2">
                                                    <label class="text-muted">Destaque</label>
                                                    <div class="form-group">
                                                        <div class="icheckbox">
                                                            <input type="radio" name="artigo_status" id="radio1" value="1" <?= $artigo->artigo_status == 1 ? 'checked' : '' ?> />
                                                            <label for="radio1" class="text-muted"> Sim </label>
                                                        </div>
                                                        <div class="icheckbox">
                                                            <input type="radio" name="artigo_status" id="radio2" value="2" <?= $artigo->artigo_status == 2 ? 'checked' : '' ?>  />
                                                            <label for="radio2" class="text-muted"> Não </label>
                                                        </div>
                                                    </div>        
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <input  name="artigo_imagem" type="file" class="file" data-show-preview="false">
                                            </div>
                                            <div class="row">
                                                <div class='box-body pad'>
                                                    <textarea id="editor" name="artigo_descricao" rows="10" cols="80"><?= $artigo->artigo_descricao ?></textarea>
                                                </div>
                                            </div>
                                            <div class=" text-center">
                                                <button type="submit" class="btn btn-primary btn-rounded">Atualizar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <?php require_once './rodape.php'; ?>
            <div class='control-sidebar-bg'></div>
        </div>
        <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
        <script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
        <script src="plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
        <script src="plugins/bootstrap-datepicker/locales/bootstrap-datepicker.pt-BR.min.js" type="text/javascript"></script>
        <script src="plugins/bootstrap-fileinput/js/fileinput.min.js" type="text/javascript"></script>
        <script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
        <script src='plugins/fastclick/fastclick.min.js'></script>
        <script src='plugins/summernote/summernote.min.js'></script>
        <script src='plugins/summernote/lang/summernote-pt-BR.js'></script>
        <script src='plugins/sweetalert/sweetalert.js'></script>
        <script src="dist/js/app.min.js" type="text/javascript"></script>
        <script src='plugins/iCheck/icheck.min.js'></script>
        <script src="dist/js/demo.js" type="text/javascript"></script>
        <script type="text/javascript">
            $(".artigoeditar").addClass('active');
            $(document).ready(function () {
                $('textarea').summernote({
                    lang: 'pt-BR',
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true
                });
            });
            $('#data').datepicker({
                orientation: "auto bottom",
                language: 'pt-BR'
            });
            $(document).ready(function () {
                $('.icheckbox').iCheck({
                    checkboxClass: 'icheckbox_square',
                    radioClass: 'iradio_square',
                    increaseArea: '20%' // optional
                });
            });
        </script> 
    </body>
</html>
