<?php

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $date = ['artigo_data' => Format::InverterData($data['artigo_data'])];
    if ($_FILES['artigo_imagem']['tmp_name'] != '') {
        $img = $_FILES['artigo_imagem']['tmp_name'];
        $filename = Format::Extension($img);
        move_uploaded_file($_FILES['artigo_imagem']['tmp_name'], "../uploads/$filename");
        $data = ['artigo_imagem' => $filename] + $data;
    }
    $array = array_merge($data, $date);
    \Models\Artigo::insert($array);
    Filter::redirect("artigo.php?cadastrado");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $atualizar = \Models\Artigo::find($data['artigo_id']);
    $date = ['artigo_data' => Format::InverterData($data['artigo_data'])];
    if ($_FILES['artigo_imagem']['tmp_name'] != '') {
        if (file_exists('../uploads/' . $atualizar->artigo_imagem)) {
            @unlink('../uploads/' . $atualizar->artigo_imagem);
        }
        $img = $_FILES['artigo_imagem']['tmp_name'];
        $filename = Format::Extension($img);
        move_uploaded_file($_FILES['artigo_imagem']['tmp_name'], "../uploads/$filename");
        $data = ['artigo_imagem' => $filename] + $data;
    } else {
        unset($data['artigo_imagem']);
    }
    $array = array_merge($data, $date);
    $atualizar->update($array);
    Filter::redirect("artigo.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $remover = \Models\Artigo::find(intval($data['artigo_id']));
    if (file_exists('../uploads/' . $remover->artigo_imagem)) {
        @unlink('../uploads/' . $remover->artigo_imagem);
    }
    $remover->delete();
    Filter::redirect("artigo.php?removido");
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

