<?php
use Models\CategoriaGaleria;

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$categorias = (new CategoriaGaleria)->show();
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>ADMIN | Galeria de Fotos</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/select2-4.0.2/dist/css/select2.min.css" rel="stylesheet" type="text/css"/>
    <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css"/>
    <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css"/>
    <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css"/>
    <link href="plugins/iCheck/all.css" rel="stylesheet" type="text/css"/>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="plugins/jQuery/html5shiv.min.js"></script>
    <script src="plugins/jQuery/respond.min.js"></script>
    <![endif]-->
</head>
<body class="skin-blue sidebar-mini">
<div class="wrapper">
    <header class="main-header">
        <?php require_once './topo.php'; ?>
    </header>
    <aside class="main-sidebar">
        <?php require_once './menu.php'; ?>
    </aside>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Galeria</h1>
            <ol class="breadcrumb">
                <li>
                    <a href="index.php">
                        <i class="fa fa-dashboard"></i>
                        Home
                    </a>
                </li>
                <li class="active">Galeria</li>
            </ol>
        </section>
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box box-primary">
                        <div class="box-header">
                            <h3 class="box-title"><i class="fa fa-save"></i> Cadastrar informações</h3>
                        </div>
                        <div class="box-body">
                            <form method="post" action="galeria_fn.php?acao=incluir">
                                <div class="modal-body" id="hoshi">
                                    <div class="form-group">
                                        <select name="categoria_galeria_id" style="width: 100%">
                                            <?php if (isset($categorias[0])): ?>
                                                <?php foreach ($categorias as $categoria): ?>
                                                    <option
                                                        value="<?= $categoria->id ?>"><?= $categoria->nome ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <label class="text-muted">Destaque</label>
                                    <div class="form-group">
                                        <div class="icheckbox">
                                            <input type="radio" name="status" id="radio1" value="1"/>
                                            <label for="radio1" class="text-muted"> Sim </label>
                                        </div>
                                        <div class="icheckbox">
                                            <input type="radio" name="status" id="radio2" value="2" checked/>
                                            <label for="radio2" class="text-muted"> Não </label>
                                        </div>
                                    </div>
                                    <span class="input input--hoshi">
                                                <input class="input__field input__field--hoshi" type="text"
                                                       name="nome" required/>
                                                <label
                                                    class="input__label input__label--hoshi input__label--hoshi-color-1"
                                                    for="nome">
                                                    <span class="input__label-content input__label-content--hoshi">Título</span>
                                                </label>
                                            </span>

                                    <div class=" text-center">
                                        <button type="submit" class="btn btn-primary btn-rounded">Cadastrar</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php require_once './rodape.php'; ?>
    <div class='control-sidebar-bg'></div>
</div>
<script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
<script src="plugins/bootstrap-datepicker/locales/bootstrap-datepicker.pt-BR.min.js" type="text/javascript"></script>
<script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
<script src='plugins/fastclick/fastclick.min.js'></script>
<script src='plugins/select2-4.0.2/dist/js/select2.min.js'></script>
<script src="dist/js/app.min.js" type="text/javascript"></script>
<script src="dist/js/demo.js" type="text/javascript"></script>
<script src='plugins/iCheck/icheck.min.js'></script>
<script type="text/javascript">
    $(".galerianovo").addClass('active');
    $('#data').datepicker({
        orientation: "auto bottom",
        language: 'pt-BR'
    });
    $(document).ready(function () {
        $("select").select2({
            placeholder: "Selecione a Categoria"
        });
    });
    $(document).ready(function () {
        $('.icheckbox').iCheck({
            checkboxClass: 'icheckbox_square',
            radioClass: 'iradio_square',
            increaseArea: '20%' // optional
        });
    });
</script>
</body>
</html>
