<?php
require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$slide = (new Models\Slide)->show();
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>ADMIN | Galeria de Fotos</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="plugins/jQuery/html5shiv.min.js"></script>
            <script src="plugins/jQuery/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="skin-blue sidebar-mini">
        <div class="wrapper">
            <header class="main-header">
                <?php require_once './topo.php'; ?>
            </header>
            <aside class="main-sidebar">
                <?php require_once './menu.php'; ?>
            </aside>
            <div class="content-wrapper">
                <section class="content-header">
                    <h1>Slide Show <small>Imagens cadastradas</small></h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Slide Show</li>
                    </ol>
                </section>

                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary">
                                <div class="box-header">
                                    <a href="slide_novo.php">
                                        <button  class="btn btn-sm btn-primary">
                                            <i class="fa fa-plus"></i>
                                            Adicionar novo
                                        </button>
                                    </a>
                                    <p></p>
                                </div>
                                <div class="box-body">
                                    <div class="row" id="galeria">
                                        <?php if (isset($slide[0])): ?>
                                            <?php foreach ($slide as $img): ?>
                                                <div class="col-md-4" id="pos_<?= $img->slide_id ?>">
                                                    <div class="text-center bg-info" >
                                                        <img src="../uploads/<?= $img->slide_imagem ?>" class="img-responsive  imgcursor" style="width: 600px;height: 250px">
                                                        <div class="margin-bottom pad">
                                                            <a href="slide_editar.php?id=<?= $img->slide_id ?>">
                                                                <button class="btn btn-sm btn-primary"><i class="fa fa-edit"></i></button>
                                                            </a>
                                                            <button class="btn btn-sm btn-danger excluir" data-url="slide_fn.php?acao=remover&AMP;slide_id=<?= $img->slide_id ?>">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <?php require_once './rodape.php'; ?>
            <div class='control-sidebar-bg'></div>
        </div>
        <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
        <script src="plugins/jQueryUI/jquery-ui-1.11.2.min.js"></script>
        <script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
        <script src='plugins/bootstrap-fileinput/js/fileinput.min.js'></script>
        <script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
        <script src='plugins/fastclick/fastclick.min.js'></script>
        <script src='plugins/sweetalert/sweetalert.js'></script>
        <script src="dist/js/app.min.js" type="text/javascript"></script>
        <script src="dist/js/demo.js" type="text/javascript"></script>
        <script type="text/javascript">
            $(".slide").addClass('active');
<?php if (isset($_GET['cadastrado'])): ?>
                _alertsuccess("Sucesso!", "Imagem Cadastrada.");
<?php endif; ?>
<?php if (isset($_GET['atualizado'])): ?>
                _alertsuccess("Sucesso!", "Imagem Atualizada.");
<?php endif; ?>
<?php if (isset($_GET['removido'])): ?>
                _alertsuccess("Deletado!", "O registro foi removido :(");
<?php endif; ?>
            $(function () {
                reloadActions();
            });
            function reloadActions() {
                $("#galeria").sortable({opacity: 0.6, cursor: "move",
                    stop: function (event, ui) {
                        var ids = $("#galeria").sortable("toArray");
                        var url = 'slide_fn.php?acao=posicao';
                        $.post(url, {item: ids}, function (data) {
                            //console.log(data)
                            _alertsuccess('Posição atualizada!');
                        });
                    }
                });
            }
        </script>
    </body>
</html>
