<?php
require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$editar = (new Models\Slide)->edit(intval($_GET['id']));
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>ADMIN | Galeria de Fotos</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="plugins/jQuery/html5shiv.min.js"></script>
            <script src="plugins/jQuery/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="skin-blue sidebar-mini">
        <div class="wrapper">
            <header class="main-header">
                <?php require_once './topo.php'; ?>
            </header>
            <aside class="main-sidebar">
                <?php require_once './menu.php'; ?>
            </aside>
            <div class="content-wrapper">
                <section class="content-header">
                    <h1>Slide Show</h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Slide Show</li>
                    </ol>
                </section>
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary">
                                <div class="box-header">
                                    <h3 class="box-title"><i class="fa fa-save"></i> Atualizar informações</h3>
                                </div>
                                <div class="box-body">
                                    <form enctype="multipart/form-data" method="post" action="slide_fn.php?acao=atualizar">
                                        <div class="modal-body" id="hoshi">
                                            <div class="form-group">
                                                <input  name="slide_imagem" type="file" class="file" data-show-preview="false" required />
                                            </div>
                                            <input  type="hidden" id="slide_id" name="slide_id" value="<?= $editar->slide_id ?>" />
                                            <div class=" text-center">
                                                <button type="submit" class="btn btn-primary btn-rounded">Atualizar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <?php require_once './rodape.php'; ?>
            <div class='control-sidebar-bg'></div>
        </div>
        <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
        <script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
        <script src='plugins/bootstrap-fileinput/js/fileinput.min.js'></script>
        <script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
        <script src='plugins/fastclick/fastclick.min.js'></script>
        <script src='plugins/sweetalert/sweetalert.js'></script>
        <script src="dist/js/app.min.js" type="text/javascript"></script>
        <script src="dist/js/demo.js" type="text/javascript"></script>
        <script type="text/javascript">
            $(".slideeditar").addClass('active');
        </script>
    </body>
</html>
