<?php

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $img = $_FILES['slide_imagem']['tmp_name'];
    $filename = Format::Extension($img);
    move_uploaded_file($_FILES['slide_imagem']['tmp_name'], "../uploads/$filename");
    $data = ['slide_imagem' => $filename];
    Models\Slide::insert($data);
    Filter::redirect("slide.php?cadastrado");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $atualizar = Models\Slide::find($data['slide_id']);
    if ($_FILES['slide_imagem']['tmp_name'] != '') {
        if (file_exists('../uploads/' . $atualizar->slide_imagem)) {
            @unlink('../uploads/' . $atualizar->slide_imagem);
        }
        $img = $_FILES['slide_imagem']['tmp_name'];
        $filename = Format::Extension($img);
        move_uploaded_file($_FILES['slide_imagem']['tmp_name'], "../uploads/$filename");
        $data = ['slide_imagem' => $filename] + $data;
    } else {
        unset($data['slide_imagem']);
    }
    $atualizar->update($data);
    Filter::redirect("slide.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $remover = Models\Slide::find($data['slide_id']);
    if (file_exists('../uploads/' . $remover->slide_imagem)) {
        @unlink('../uploads/' . $remover->slide_imagem);
    }
    $remover->delete();
    Filter::redirect("slide.php?removido");
}

function posicao() {
    $item = $_POST['item'];
    foreach ($item as $pos => $id) {
        $slide_id = preg_replace('/pos_/', ' ', $id);
        Models\Slide::where('slide_id', '=', $slide_id)
                ->update(['slide_pos' => $pos]);
    }
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}
