<?php

require_once __DIR__ . '/../vendor/autoload.php';

function login() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $verifica = (new Models\Usuario)->Verifica($data['usuario_email']);
    if (password_verify($data['usuario_senha'], $verifica->usuario_senha)) {
        $sid = new Model\Session();
        $sid->start();
        $sid->init(36000);
        $sid->addNode('start', date('d/m/Y - h:i'));
        $sid->addNode('nome', $verifica->usuario_nome);
        $sid->addNode('imagem', $verifica->usuario_imagem);
        Filter::redirect("index.php");
    } else {
        Filter::redirect("login.php?erro");
    }
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

    