<?php

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $thumb = ['video_thumb' => Format::video_thumb($data['video_url'])];
    $array = array_merge($data, $thumb);
    \Models\Video::insert($array);
    Filter::redirect("video.php?adicionado");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $thumb = ['video_thumb' => Format::video_thumb($data['video_url'])];
    $array = array_merge($data, $thumb);
    \Models\Video::where('video_id', '=', $data['video_id'])->update($array);
    Filter::redirect("video.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    \Models\Video::where('video_id', '=', $data['video_id'])->delete();
    Filter::redirect("video.php?removido");
}

function Json() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $jason = \Models\Video::find($data['video_id']);
    echo $jason;
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

    