<?php

namespace Models;

require_once __DIR__ . '/../../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Slide
 * Gerência imagens do slide show
 */
class Slide extends Eloquent {

    protected $primaryKey = 'slide_id';
    protected $table = 'slide';
    public $timestamps = false;
    protected $fillable = [
        'slide_nome', 'slide_nome', 'slide_imagem',
    ];

    public function edit($id) {
        return Slide::find($id);
    }

    public function show() {
        return Slide::orderBy('slide_pos', 'ASC')->get();
    }

}
