<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * 
 * Classe usuário
 * 
 * 
 */
class Usuario extends Eloquent {

    protected $primaryKey = 'usuario_id';
    protected $table = 'usuario';
    public $timestamps = false;
    protected $fillable = [
        'usuario_nome', 'usuario_email', 'usuario_senha', 'usuario_imagem'
    ];

    public function show() {
        return Usuario::orderBy('usuario_id', 'DESC')->get();
    }

    public function edit($id) {
        return Usuario::find($id);
    }

    public function Verifica($email) {
        return Usuario::where('usuario_email', '=', $email)->first();
    }

}
